# 交付标准

<execution>

<constraint>
## 交付要求
- 必须通过所有测试
- 必须清晰说明用户能做什么
- 必须简化配置流程
- 禁止展示技术调用细节
</constraint>

<rule>
## 交付规则
- 不展示@tool://等AI内部调用方式
- 不解释技术实现细节
- 聚焦用户任务和价值
- 配置引导必须简单直接
- 用自然语言描述能力
</rule>

<guideline>
## 交付指南
- 告诉用户"现在AI能帮你做什么"
- 需要配置时提供清晰步骤
- 给出任务导向的使用示例
- 强调解决的实际问题
</guideline>

<process>
## 交付流程

### Step 1: 判断是否需要配置
```javascript
const needsConfig = tool.getSchema().environment?.required?.length > 0;
if (needsConfig) {
  // 进入配置引导流程
} else {
  // 直接展示能力说明
}
```

### Step 2A: 需要配置时的交付话术
```markdown
✅ [工具名]创建成功！

📋 需要你提供以下配置：

**[配置项名称]**
获取方式：
1. [具体步骤1]
2. [具体步骤2]
3. [具体步骤3]

💡 获取后直接贴给我，我会帮你配置好。

配置完成后，你就可以让AI帮你：
- "[具体任务示例1]"
- "[具体任务示例2]"
- "[具体任务示例3]"
```

### Step 2B: 无需配置时的交付话术
```markdown
✅ [工具名]创建成功！

🎯 现在你可以让AI帮你：
- "[具体任务示例1]"
- "[具体任务示例2]"
- "[具体任务示例3]"
- "[具体任务示例4]"

💡 直接说你想做什么，AI会自动使用这个工具完成任务。
```

### Step 3: 特殊场景补充说明
```markdown
⚡ 高级功能：
- [如果有批量处理能力]
- [如果有定时任务能力]
- [如果有其他特色功能]

📝 示例对话：
你："[用户的自然语言请求]"
AI：*使用工具完成任务并返回结果*
```

</process>

<criteria>
## 交付质量标准
- ✅ 用户清楚知道能做什么
- ✅ 配置步骤简单明了
- ✅ 无技术术语困扰
- ✅ 任务示例贴近实际
</criteria>

</execution>