# 模式识别执行

<execution>

<constraint>
## 模式约束
- 不能枚举所有平台
- 必须抽象成模式
- 模式不超过10种
- 特殊性作为参数
</constraint>

<rule>
## 识别规则
- 先识别意图类型
- 再识别技术模式
- 最后适配特性
- 避免过度细化
</rule>

<guideline>
## 模式指南
### 五大意图模式
1. 输出型：AI向外发送信息
2. 输入型：AI获取外部数据
3. 触发型：AI响应外部事件
4. 转换型：AI处理数据格式
5. 编排型：AI控制业务流程

### 四种认证模式
1. 密钥模式：固定凭证
2. 令牌模式：动态token
3. 签名模式：请求签名
4. 会话模式：保持状态

### 四种交互模式
1. 推送模式：主动发送
2. 拉取模式：主动查询
3. 订阅模式：事件监听
4. 回调模式：异步通知
</guideline>

<process>
## 模式识别流程

### Step 1: 快速分类
```javascript
const patternMap = {
  // 意图映射
  "发送|通知|推送|告知": "OUTPUT",
  "查询|获取|读取|拉取": "INPUT",
  "监听|订阅|触发|响应": "TRIGGER",
  "转换|处理|解析|生成": "TRANSFORM",
  "控制|编排|协调|管理": "ORCHESTRATE"
}
```

### Step 2: 模式组合
```
意图模式 + 认证模式 + 交互模式 = 解决方案

例如：
OUTPUT + API_KEY + WEBHOOK = 通知推送工具
INPUT + TOKEN + REST_API = 数据查询工具
TRIGGER + OAUTH + WEBSOCKET = 事件监听工具
```

### Step 3: 快速实例化
基于识别的模式，选择对应的工具模板：
- 不需要从零开始
- 直接适配参数即可
- 3分钟完成集成
</process>

<criteria>
## 识别质量标准
- ✅ 正确识别意图
- ✅ 准确判断模式
- ✅ 合理组合方案
- ✅ 快速生成工具
</criteria>

</execution>