# 技术调研流程

<execution>

<constraint>
## 调研约束
- 使用外部依赖前必须调研
- 有WebSearch/WebFetch时必须使用
- 调研时间控制在2分钟内
- 不确定的技术点必须验证
- 优先查官方文档
</constraint>

<rule>
## 调研规则
- npm包 → 先查文档再使用
- API调用 → 先验证格式再实现
- 模块导入 → 先确认方式再编码
- 遇到错误 → 先搜索方案再修复
- 记忆不确定 → 先验证再应用
</rule>

<guideline>
## 调研指南
### 调研触发条件
- 使用任何外部npm包
- 调用第三方API
- 不确定的技术实现
- 记忆中模糊的用法
- 之前出现过错误的模式

### 调研信息优先级
1. 官方文档（最可信）
2. npm页面说明
3. GitHub README
4. 最新的使用示例
5. 社区最佳实践
</guideline>

<process>
## 技术调研流程

### Step 1: 识别调研需求
评估技术点的确定性：
- 🟢 完全确定：可直接使用
- 🟡 部分确定：需要验证细节
- 🔴 不确定：必须全面调研

### Step 2: 选择调研方式
```
优先级顺序：
1. WebSearch可用 → 搜索官方文档和示例
2. WebFetch可用 → 获取npm页面或文档
3. 都不可用 → 采用保守实现方案
```

### Step 3: 执行调研
关键调研点：
- **导入方式**：CommonJS还是ESM？默认导出还是命名导出？
- **API签名**：参数类型、顺序、可选性
- **返回格式**：Promise？回调？同步？返回值结构？
- **错误处理**：错误类型、错误码、重试策略
- **版本兼容**：最低版本要求、Breaking Changes

### Step 4: 验证和记录
调研结果验证：
- 来源可信度评估
- 版本时效性检查
- 与PromptX环境兼容性确认

记录格式：
```javascript
// 在实现代码前添加调研注释
// 调研确认：mysql2使用mysql2/promise导入
// 返回格式：[rows, fields] = await connection.execute()
// 来源：npm官方文档 v3.x
```
</process>

<criteria>
## 调研质量标准
- ✅ 核心API用法已确认
- ✅ 返回值格式已明确
- ✅ 错误处理方式已了解
- ✅ 有可信来源支撑
- ✅ 版本兼容性已验证
</criteria>

</execution>