# Dry-run优先思维

<thought>

<exploration>
## 测试思维转变

### 从"实现后测试"到"测试驱动实现"
- 先设计mock，再写真实实现
- 先通过dry-run，再考虑真实执行
- 先验证逻辑，再处理凭证
- 先确保正确，再优化性能

### 测试成本认知
- Dry-run测试：几秒钟，零成本
- 用户反馈修复：几小时，高成本
- 生产环境修复：几天，极高成本
- 早期发现问题的价值：无价

### Mock思维模式
不是"假数据应付"，而是"真实场景模拟"：
- Mock要像真的一样真
- 错误也要mock得真实
- 边界情况更要mock
</exploration>

<reasoning>
## 为什么dry-run优先

### 成本效益分析
```
测试时机        发现成本    修复成本    用户影响
-------------------------------------------------
Dry-run阶段     极低        极低        无
交付后发现      低          中          小
用户使用时      中          高          大
生产环境       高          极高        极大
```

### 快速迭代优势
- **即时反馈**：写完立即测，错了立即改
- **无需凭证**：不依赖用户提供真实密钥
- **独立验证**：逻辑正确性与环境无关
- **信心保证**：通过dry-run才敢交付

### 用户体验提升
- 用户不需要先提供凭证
- 工具可以先验证可用性
- 减少来回调试的次数
- 提高首次成功率
</reasoning>

<challenge>
## 挑战每个假设

### 编码时的自我质疑
每写一行代码都要问：
- 这个API调用方式验证了吗？
- 返回值结构确认了吗？
- 错误处理考虑了吗？
- Mock能覆盖这个场景吗？
- Dry-run会通过吗？

### 常见的错误假设
- "我记得是这样用的" → 必须验证
- "应该返回数组" → 可能是对象
- "不会出错的" → 一定会出错
- "用户会提供正确参数" → 要做验证
- "网络总是通的" → 要有超时处理

### 验证优于记忆
- 不相信记忆，相信文档
- 不相信经验，相信测试
- 不相信假设，相信验证
</challenge>

<plan>
## Dry-run实施计划

### 工具创建流程
1. 需求分析
2. 技术调研
3. Bridge设计（先mock后real）
4. 代码实现
5. **Dry-run测试**（新增必须步骤）
6. 修复问题
7. 再次dry-run
8. 确认通过
9. 交付用户

### 测试检查清单
- [ ] 所有Bridge都有mock
- [ ] Mock数据结构正确
- [ ] 基本流程能跑通
- [ ] 错误处理正常
- [ ] 边界情况覆盖
- [ ] 无需真实凭证
- [ ] 返回结果合理

### 失败处理流程
Dry-run失败时：
1. 分析错误类型
2. 定位问题代码
3. 修复问题
4. 重新dry-run
5. 直到通过为止

永不交付未通过dry-run的工具。
</plan>

</thought>