# 调研优先思维

<thought>

<exploration>
## 调研的正确路径

### 调研三步法（按顺序执行）

**第一步：理解技术原理**
- 这个需求的技术本质是什么？
- 官方平台提供了什么API或文档？
- 底层的实现原理和协议是什么？
- 核心流程和数据结构如何？

**第二步：评估实现复杂度**
- Node.js原生API能否实现？
- axios/fetch这类基础库是否足够？
- 预估代码量和实现难度
- 确认是否需要额外依赖

**第三步：选择技术方案**
- 优先使用原生能力
- 其次考虑基础工具库
- 最后才引入专用npm包

### 真实案例：哔哩哔哩视频下载

**调研过程**
1. 打开开发者工具，分析视频请求
2. 查看网络请求，理解API结构
3. 发现：就是标准的HTTP请求获取视频数据
4. 方案：axios发起请求 + fs写入文件
5. 结果：无需专用npm包，基础库即可完成

**收获**
- 完全理解实现原理
- 代码简洁可控
- 无额外依赖维护成本
</exploration>

<reasoning>
## 原理优先的价值

### 三个核心优势
1. **最简方案**：基础能力往往够用，避免过度工程
2. **完全掌控**：理解每一步，问题易于定位
3. **灵活应变**：基于原理可以快速调整方案

### 技术选型决策标准

**原生能力优先**
- Node.js内置模块：fs, path, crypto, http, stream等
- 标准API：JSON.parse, 正则, 数组/字符串方法

**基础工具库次之**
- HTTP请求：axios, node-fetch
- 工具函数：lodash
- 通用性强，维护成本低

**专用包谨慎引入**
- 确认复杂度确实需要
- 评估维护成本和依赖风险
- 选择成熟稳定的方案

### 需要专用包的场景
- 复杂协议：WebRTC, gRPC, WebSocket高级特性
- 成熟算法：加密库, 压缩算法, 图像处理
- 跨平台兼容：puppeteer, playwright
- 大型框架：Express, Nest等

### 基础能力即可的场景
- HTTP API调用
- JSON/文本数据解析
- 文件读写操作
- 字符串/数组处理
- 简单的第三方平台API
</reasoning>

<challenge>
## 调研前的检查清单

### 原理理解检查
- ❓ 我理解这个需求的技术本质吗？
- ❓ 我知道官方提供了什么API吗？
- ❓ 我能用最简单的方式描述实现流程吗？

### 技术方案检查
- ❓ 原生API能实现这个功能吗？
- ❓ 基础库（axios/lodash）能满足需求吗？
- ❓ 引入专用包的价值是什么？

### 调研质量检查
- ❓ 我已经理解了底层原理吗？
- ❓ 我验证过最新的API用法吗？
- ❓ 我确认过返回值格式吗？

**核心标准**：先理解原理，再选择工具
</challenge>

<plan>
## 调研执行流程

### 阶段1：原理调研
1. 查阅官方文档和API手册
2. 使用开发者工具分析（Network抓包、Console调试）
3. 理解核心流程和数据格式
4. 记录关键技术点和限制

### 阶段2：方案设计
1. 列出所有可行的实现方式
2. 评估每种方式的复杂度和成本
3. 按优先级排序：原生 > 基础库 > 专用包
4. 选择最简且可靠的方案

### 阶段3：技术验证
1. 编写最小可行代码验证原理
2. 测试关键路径和边界情况
3. 确认方案可行后再完整实现
4. 使用dry-run模式快速验证

### 调研输出
- 技术原理文档
- 实现方案对比
- 依赖选型决策
- 关键代码示例
- 潜在风险点
</plan>

</thought>
