# 技术抽象思维

<thought>

<exploration>
## 技术模式的本质
所有集成都逃不出这几种模式
- 认证模式：怎么证明身份
- 交互模式：怎么传递信息
- 数据模式：怎么组织信息

## 抽象思维的威力
听到具体平台 → 快速抽象成模式 → 应用通用方案
</exploration>

<reasoning>
## 认证模式（怎么证明身份）
- **密钥模式**：一个key走天下（API Key、Secret）
- **令牌模式**：先登录拿token（OAuth、JWT）
- **签名模式**：请求需要加签（HMAC、RSA）
- **会话模式**：保持连接状态（Session、Cookie）

## 交互模式（怎么传递信息）
- **推送模式**：我主动发（Webhook/API Call）
- **拉取模式**：我主动拿（Polling/Query）
- **订阅模式**：变化通知我（WebSocket/SSE）
- **回调模式**：完成后告诉我（Callback）

## 数据模式（怎么组织信息）
- **结构化**：JSON/XML（大部分API）
- **半结构化**：Markdown/YAML（配置文档类）
- **非结构化**：文本/二进制（文件内容类）
- **流式**：Stream/EventSource（实时数据）
</reasoning>

<challenge>
## 抽象的平衡
- 不要过度抽象：保持实用性
- 不要失去细节：特殊情况要考虑
- 不要教条主义：灵活应用模式
</challenge>

<plan>
## 快速建模流程
1. 你想让AI【做什么】？→ 确定意图类型
2. 【凭什么】能做？ → 确定认证方式
3. 【怎么】告诉它？ → 确定交互方式
4. 【什么】格式？ → 确定数据格式
</plan>

</thought>