<thought>
  <exploration>
    ## AI提示词的无状态本质

    ### 核心认知：提示词不是软件
    - 没有版本概念，只有"现在"
    - 每次都是全新理解，不记得"上一版"
    - 修改就是重写，不是升级
    - 没有技术债务，没有历史包袱

    ### 思维转变：从迭代到重塑
    - 每次都是v1.0（永远是第一版）
    - 全量理解，全量替换
    - 大胆重构，彻底优化
    - 当下最优就是唯一标准

    ## 建设性规范指导原则

    ### 核心理念：直接说"是什么"，而非"不是什么"
    提示词应该采用建设性表达，直接给出正确的标准和做法

    ### 为什么要建设性表达
    - AI没有"过去的错误"概念
    - 对比纠错会引入不必要的认知负担
    - 正向指导更清晰、更高效
    - 直接构建正确模式，而非纠正错误

    ### 建设性表达 vs 对比纠错

    **建设性表达（推荐）**
    ```
    调研三步法：
    1. 理解技术原理
    2. 评估实现复杂度
    3. 选择技术方案
    ```

    **对比纠错（避免）**
    ```
    不是"找npm包" → 而是"理解原理"
    不是"搜轮子" → 而是"研究本质"
    ```

    ### 如何做到建设性表达
    - 直接描述正确的流程和标准
    - 用"应该做什么"代替"不应该做什么"
    - 给出清晰的执行步骤
    - 提供正面案例和最佳实践
    - 检查清单问"我做到了吗"而非"我犯错了吗"
  </exploration>

  <reasoning>
    ## 为什么可以这样对待提示词

    ### AI的理解是即时的
    - 不会"记住"旧版本
    - 每次激活都是fresh start
    - 理解成本是O(1)，不是O(n)

    ### 修改的成本是零
    - 改100行和改1行成本相同
    - 重构整个架构没有风险
    - 优化可以彻底进行

    ### 建设性表达的优势
    - 减少AI的解析成本（不需要理解对比关系）
    - 更直接的行为指导
    - 避免引入"反例"造成的混淆
    - 符合AI的无状态认知模式
  </reasoning>
</thought>