# 工具文档注释理念

<thought>

<exploration>
## 工具注释的本质思考

### 为什么要写注释？
- **不是**为了解释代码怎么工作（代码本身应该清晰）
- **不是**为了重复文档内容（文档会自动生成）
- **而是**为了阐述工具的战略价值和设计理念

### 注释的读者是谁？
- 未来的开发者（包括未来的自己）
- 需要理解「为什么」而非「怎么做」
- 需要理解工具在整个系统中的定位

### 什么样的注释有价值？
- 解释工具存在的战略意义
- 阐述设计决策背后的权衡
- 说明工具如何融入更大的生态
</exploration>

<reasoning>
## 注释价值层次模型

### Level 1: 功能描述（低价值）
```javascript
// 这个工具用来操作文件系统
```
问题：文档里已经有了

### Level 2: 技术实现（中等价值）
```javascript
// 基于 MCP 协议包装，提供统一接口
```
问题：开发者看代码能明白

### Level 3: 设计理念（高价值）
```javascript
// 通过沙箱隔离确保 AI Agent 不会破坏系统稳定性
```
价值：解释了设计选择的原因

### Level 4: 战略意义（最高价值）
```javascript
// 作为 PromptX 生态的基础设施，确保平台独立性
```
价值：说明了工具的战略定位
</reasoning>

<challenge>
## 常见的无效注释模式

### ❌ 重复代码的注释
```javascript
// 读取文件
readFile(path)
```

### ❌ 重复文档的注释
```javascript
// 参数：path - 文件路径
// 返回：文件内容
```

### ❌ 显而易见的注释
```javascript
// 初始化变量
let result = null;
```

### ❌ 过度技术细节
```javascript
// 使用 fs.readFileSync 同步读取以避免回调地狱
```
</challenge>

<plan>
## 工具注释最佳实践

### 文件头部注释模板
```javascript
/**
 * [工具名] - [一句话定位]
 * 
 * 战略意义：
 * 1. [核心价值 1]：具体解释
 * 2. [核心价值 2]：具体解释
 * 3. [核心价值 3]：具体解释
 * 
 * 设计理念：
 * [一段话说明设计的核心思想，解释为什么这样设计]
 * 
 * 生态定位：
 * [说明工具在 PromptX 体系中的位置和作用]
 */
```

### 注释内容指南

#### 1. 战略意义（必须包含）
- **架构价值**：如何保护系统稳定性
- **平台价值**：如何实现平台独立
- **生态价值**：如何支撑其他组件

#### 2. 设计理念（推荐包含）
- **核心权衡**：为什么选择这种方案
- **关键决策**：重要的设计选择
- **未来扩展**：预留的扩展空间

#### 3. 生态定位（可选包含）
- **依赖关系**：依赖和被依赖
- **协作模式**：与其他工具的配合
- **演进方向**：未来可能的发展

### 注释长度控制
- 文件头注释：5-15行
- 每个要点：1-2句话
- 总体原则：精炼而有深度

### 质量检验标准
✅ 删掉这段注释，会失去重要信息吗？
✅ 这些信息在文档中找不到吗？
✅ 未来的开发者看到会觉得有价值吗？
✅ 解释了「为什么」而非「是什么」吗？
</plan>

</thought>