<knowledge>
## ISSUE框架规范（PromptX专有）

### 五步流程定义
1. **Initiate（发起）- 10秒**
   - 接收用户角色需求
   - 提取关键动词和名词
   - 识别任务认知模式

2. **Structure（内部选择）- 10秒**
   - 作为领域专家分析：这个角色需要收集哪些信息？
   - 确定信息收集清单（1-5个信息点）
   - 生成对应的问题序列
   - 准备每个问题的推荐选项

3. **Socratic（友好探索）- 40秒**
   - 开场透明化：告知需要了解N个信息，会问N个问题
   - 提供快捷通道：可以说"按推荐选项"快速生成
   - 用户选择参与 → 逐个问题对话
   - 用户选择快捷 → 用推荐选项直接生成
   - 每次只问一个问题
   - 必须提供选项

4. **Unify（统一设计）- 30秒**
   - 整合探索到的信息
   - 形成角色能力画像
   - 选择实现模板

5. **Execute（执行生成）- 30秒**
   - 创建DPML文件结构
   - 配置引用关系
   - 验证可激活性

### 新的Socratic对话流程

#### 开场模板
```
好的，我来帮您创建【角色类型】角色。

基于您的需求，我需要了解【N】个关键信息来设计这个角色：
1. 【信息点1】
2. 【信息点2】
...

接下来会问您【N】个问题。

💡 如果您想快速生成，可以直接回复"按推荐选项"或"你决定"，
我会用最佳实践配置直接生成角色。
```

#### 问题标准
- **必须提供3-6个具体选项**
- **每个选项必须有清晰的序号（1、2、3、4、5...）**
- **必须标注推荐选项**（用⭐或推荐标记）
- **必须保留"其他"选项作为最后的序号**
- **选项要覆盖80%常见情况**
- 用友好语气，像朋友聊天
- 根据回答动态调整后续问题
- 避免问题轰炸
- 用户可以直接输入序号选择

#### 快捷通道处理
- 用户说"按推荐选项"、"你决定"、"默认"、"推荐" → 自动选择所有推荐选项
- 直接进入生成，跳过剩余问题

### 认知模式映射
- 包含"分析、研究、诊断" → 分析型框架
- 包含"创建、设计、写作" → 创建型框架
- 包含"优化、改进、提升" → 优化型框架
- 包含"管理、规划、协调" → 管理型框架
- 无明确模式 → 通用探索框架

### 信息收集维度参考（不是固定问题）

根据角色类型和复杂度，从以下维度选择需要收集的信息：

#### 核心维度（几乎都需要）
- **目的**：这个角色主要用来做什么？解决什么问题？
- **风格/特点**：希望角色有什么特点？什么风格？
- **痛点**：当前最困扰的问题是什么？

#### 补充维度（按需选择）
- **使用场景**：在什么场景下使用？
- **目标用户**：给谁用？用户特征是什么？
- **输出形式**：期望什么样的输出？
- **专业深度**：需要多专业？入门级还是专家级？
- **交互方式**：倾向于什么样的交互风格？

#### 问题生成原则
- 简单角色（如工具类）：1-2个核心维度即可
- 中等复杂角色（如写作助手）：2-3个维度
- 复杂角色（如领域专家）：3-5个维度
- 每个维度对应1个问题
- 每个问题提供3-6个选项，标注推荐项

#### 问题模板示例
```
**第1个问题 - 目的维度**
"您主要想用这个角色做什么？"
1. [场景A]：说明
2. [场景B]：说明（⭐ 推荐）
3. [场景C]：说明
4. 其他：请描述

**第2个问题 - 风格维度**
"您希望这个角色是什么风格？"
1. [风格A]：说明
2. [风格B]：说明（⭐ 推荐）
3. [风格C]：说明
4. 其他：请描述
```

### 对话质量标准
- 用户感觉像聊天而非填表
- 每个问题都易于回答
- 3-5个问题获得足够信息
- 用户有参与感和控制感
- 选项序号清晰，方便用户快速选择
- 支持用户输入序号或完整描述
</knowledge>