<thought>
  <exploration>
    ## 动态深度原则：让文章有山峰有山谷

    ### AI写作的均匀化病症
    - 每个章节300字，不多不少
    - 每个观点3个论据，整整齐齐
    - 每段都点到为止，深度一致
    - 结果：读起来像教科书，毫无重点

    ### 真实写作的不均衡美
    - 有料的地方洋洋洒洒1000字
    - 没料的地方一句话带过
    - 核心观点反复强调、多角度论证
    - 次要内容轻描淡写甚至删除

    ### 信息密度驱动笔墨深度
    - **核心原则**：有料写深，无料略过
    - 不是每个章节都值得展开
    - 不是每个观点都需要三个论据
    - 让信息的丰富程度决定篇幅
  </exploration>

  <reasoning>
    ## 为什么要动态分配笔墨

    ### 信息密度决定价值密度
    - 收集到丰富信息的部分 = 文章的价值高地
    - 信息贫瘠的部分 = 不要硬撑场面
    - 读者时间有限，要把最好的给他们
    - 详略得当才能突出重点

    ### 不均衡创造节奏感
    - 均匀是机器的特征，不均匀才是人的特征
    - 快慢交替形成阅读节奏
    - 重点突出才能被记住
    - 该快则快，该慢则慢

    ### 真实性的体现
    - 人类作者也是这样写的
    - 熟悉的多写，陌生的少写
    - 有感触的展开，没感触的跳过
    - 这种不均衡反而真实
  </reasoning>

  <challenge>
    ## 动态深度的实施挑战

    ### 克服均衡强迫症
    - AI倾向于结构对称
    - 每部分都想写够字数
    - 需要主动打破这种倾向

    ### 判断信息价值
    - 什么算"有料"？
    - 如何评估信息密度？
    - 需要建立清晰标准

    ### 避免虎头蛇尾
    - 不是简单的前详后略
    - 而是根据信息分布调整
    - 可能中间某章节最丰富
  </challenge>

  <plan>
    ## 动态深度操作指南

    ### Step 1: 信息密度评估（在Socratic和Search后）

    **评估维度**：
    - **独特性**：是否是独家信息/个人经历？
    - **具体性**：有细节故事还是只有概念？
    - **情感性**：是否触发强烈情感共鸣？
    - **数据性**：是否有有力的数据支撑？

    **打分标准**：
    ```
    🔥🔥🔥 深挖区（3分）：独特+具体+情感丰富
    🔥🔥 正常区（2分）：有一定信息但不突出
    🔥 浅尝区（1分）：通用信息或概念性内容
    ```

    ### Step 2: 笔墨分配地图（在Unify阶段制定）

    **分配原则**：
    - 深挖区：30-50%的总笔墨，详细展开
    - 正常区：15-25%的总笔墨，正常叙述
    - 浅尝区：5-10%的总笔墨，一笔带过

    **地图示例**：
    ```
    文章总长2000字的分配：
    - 开头（痛点故事丰富）🔥🔥🔥 → 600字深挖
    - 原因分析（只有概念）🔥 → 100字带过
    - 解决方案（有数据有案例）🔥🔥 → 400字展开
    - 实践经验（用户独特经历）🔥🔥🔥 → 700字重点
    - 总结（常规收尾）🔥 → 200字简述
    ```

    ### Step 3: 差异化写作策略

    **深挖区写法**：
    - 完整的故事叙述
    - 多角度分析论证
    - 丰富的细节描写
    - 可以有对话、场景还原
    - 不怕篇幅长，把话说透

    **正常区写法**：
    - 观点+一个例子+简单分析
    - 保持叙述连贯
    - 不过度展开
    - 点到为止但逻辑完整

    **浅尝区写法**：
    - 一两句话概括
    - 甚至可以合并到其他章节
    - 绝不硬凑字数
    - 宁可删除也不要注水

    ### Step 4: 执行检查清单

    - [ ] 信息丰富的部分是否充分展开？
    - [ ] 信息贫瘠的部分是否简化处理？
    - [ ] 全文是否有明显的详略对比？
    - [ ] 重点部分是否占据主要篇幅？
    - [ ] 是否勇敢地一笔带过了某些部分？

    ### 核心口诀
    **"有料深挖一千字，无料一句就带过"**
    - 不要为了结构牺牲内容
    - 不要为了均衡放弃重点
    - 让信息密度主导文章节奏
    - 该长则长，该短则短
  </plan>
</thought>