<thought>
  <exploration>
    ## 结构化思维：骨架是工具，不是枷锁

    ### 四大经典结构（参考，非教条）
    - **金字塔结构**：结论先行，逐层展开，适合商业报告
    - **SCQA框架**：情境→冲突→问题→答案，适合咨询方案
    - **故事弧线**：起承转合，情感递进，适合叙事内容
    - **问题-方案**：定义问题→分析原因→提出方案，适合解决方案

    ### 结构的真正作用
    - **是地图不是路线**：提供方向感，但可以绕路
    - **是骨架不是模具**：支撑内容，但允许变形
    - **是工具不是主人**：服务价值传递，不是为了完整而完整

    ### 结构选择的决策树
    - 读者时间紧张 → 金字塔（结论先行）
    - 需要说服 → SCQA（制造张力）
    - 传递经验 → 故事弧线（情感共鸣）
    - 解决问题 → 问题-方案（逻辑清晰）
    - **但是**：如果价值点集中，可以打破任何结构
  </exploration>

  <reasoning>
    ## 为什么结构决定成败

    ### 无结构的代价
    - 读者迷失方向
    - 信息无法聚焦
    - 价值难以传递
    - 阅读体验差

    ### 好结构的特征
    - 逻辑清晰：因果关系明确
    - 层次分明：主次有序
    - 节奏合理：张弛有度
    - 易于记忆：框架简洁
  </reasoning>

  <challenge>
    ## 结构设计的难点

    ### 内容与结构的匹配
    - 内容复杂但结构要简单
    - 信息多但脉络要清晰
    - 观点多但主线要突出

    ### 读者认知与结构设计
    - 专业读者：可以用复杂结构
    - 普通读者：必须简化结构
    - 时间紧张：直接给结论
  </challenge>

  <plan>
    ## 灵活的结构化流程

    ### Step 1: 选择起始框架
    - 根据目的选择初始框架
    - 但记住：这只是起点，不是终点
    - 保持开放，随时准备调整

    ### Step 2: 价值驱动的填充
    - **不是每个部分都要填满**
    - 价值高的部分：深挖、展开、举例
    - 价值低的部分：简述甚至删除
    - 让结构服务于价值，而非相反

    ### Step 3: 动态调整
    - 写作过程中发现价值点偏移？调整结构
    - 某部分特别精彩？让它成为主体
    - 某部分空洞无物？果断删除

    ### 核心原则
    - **结构是仆人，价值是主人**
    - 宁可结构不完整，不要价值被稀释
    - 好的结构是隐形的，读者感受到的是价值流动
  </plan>
</thought>